# Copyright (C) 2003 Nominum, Inc.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND NOMINUM DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL NOMINUM BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: TXT.py,v 1.3 2003/05/30 06:48:45 halley Exp $

import socket

import DNS.rdata
import DNS.tokenizer

class TXT(DNS.rdata.Rdata):
    def __init__(self, rdclass, rdtype, strings):
        super(TXT, self).__init__(rdclass, rdtype)
        if isinstance(strings, str):
            strings = [ strings ]
        self.strings = strings[:]

    def to_text(self, **kw):
        txt = ''
        prefix = ''
        for s in self.strings:
            txt += '%s"%s"' % (prefix, s)
            prefix = ' '
        return txt
        
    def from_text(cls, rdclass, rdtype, tok, origin = None):
        strings = []
        while 1:
            (ttype, s) = tok.get()
            if ttype == DNS.tokenizer.EOL or ttype == DNS.tokenizer.EOF:
                break
            if ttype != DNS.tokenizer.QUOTED_STRING:
                raise SyntaxError, "expected a quoted string"
            if len(s) > 255:
                raise SyntaxError, "string too long"
            strings.append(s)
        return cls(rdclass, rdtype, strings)
    
    from_text = classmethod(from_text)

    def to_wire(self, file, compress = None, origin = None):
        for s in self.strings:
            l = len(s)
            assert l < 256
            byte = chr(l)
            file.write(byte)
            file.write(s)
        
    def from_wire(cls, rdclass, rdtype, wire, current, rdlen, origin = None):
        strings = []
        while rdlen > 0:
            l = ord(wire[current])
            current += 1
            rdlen -= 1
            if l > rdlen:
                raise SyntaxError
            s = wire[current : current + l]
            current += l
            rdlen -= l
            strings.append(s)
        return cls(rdclass, rdtype, strings)

    from_wire = classmethod(from_wire)

    def __cmp__(self, other):
        return cmp(self.strings, other.strings)
