# Copyright (C) 2003 Nominum, Inc.
#
# Permission to use, copy, modify, and distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND NOMINUM DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL NOMINUM BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: A.py,v 1.3 2003/05/30 06:48:45 halley Exp $

import socket

import DNS.rdata
import DNS.tokenizer

class A(DNS.rdata.Rdata):
    def __init__(self, rdclass, rdtype, address):
        super(A, self).__init__(rdclass, rdtype)
        # check that it's OK
        junk = socket.inet_aton(address)
        self.address = address

    def to_text(self, **kw):
        return self.address
        
    def from_text(cls, rdclass, rdtype, tok, origin = None):
        (ttype, address) = tok.get()
        if ttype != DNS.tokenizer.IDENTIFIER:
            raise SyntaxError
        t = tok.get_eol()
        return cls(rdclass, rdtype, address)
    
    from_text = classmethod(from_text)

    def to_wire(self, file, compress = None, origin = None):
        file.write(socket.inet_aton(self.address))
        
    def from_wire(cls, rdclass, rdtype, wire, current, rdlen, origin = None):
        address = socket.inet_ntoa(wire[current : current + rdlen])
        return cls(rdclass, rdtype, address)

    from_wire = classmethod(from_wire)

    def __cmp__(self, other):
        return cmp(self.address, other.address)
