# Copyright (C) 2003 Nominum, Inc.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose with or without fee is hereby granted,
# provided that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND NOMINUM DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL NOMINUM BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: tokenizer.py,v 1.3 2003/06/20 07:12:38 halley Exp $

import unittest

import DNS.exception
import DNS.tokenizer

class TokenizerTestCase(unittest.TestCase):
        
    def testQuotedString1(self):
        tok = DNS.tokenizer.Tokenizer(r'"foo"')
        (ttype, value) = tok.get()
        self.failUnless(ttype == DNS.tokenizer.QUOTED_STRING and
                        value == 'foo')

    def testQuotedString2(self):
        tok = DNS.tokenizer.Tokenizer(r'""')
        (ttype, value) = tok.get()
        self.failUnless(ttype == DNS.tokenizer.QUOTED_STRING and
                        value == '')

    def testQuotedString3(self):
        tok = DNS.tokenizer.Tokenizer(r'"\"foo\""')
        (ttype, value) = tok.get()
        self.failUnless(ttype == DNS.tokenizer.QUOTED_STRING and
                        value == '"foo"')

    def testQuotedString4(self):
        tok = DNS.tokenizer.Tokenizer(r'"foo\010bar"')
        (ttype, value) = tok.get()
        self.failUnless(ttype == DNS.tokenizer.QUOTED_STRING and
                        value == 'foo\x0abar')

    def testQuotedString5(self):
        def bad():
            tok = DNS.tokenizer.Tokenizer(r'"foo')
            (ttype, value) = tok.get()
        self.failUnlessRaises(DNS.exception.UnexpectedEnd, bad)

    def testQuotedString6(self):
        def bad():
            tok = DNS.tokenizer.Tokenizer(r'"foo\01')
            (ttype, value) = tok.get()
        self.failUnlessRaises(DNS.exception.SyntaxError, bad)

if __name__ == '__main__':
    unittest.main()
