# Copyright (C) 2003 Nominum, Inc.
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose with or without fee is hereby granted,
# provided that the above copyright notice and this permission notice
# appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND NOMINUM DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL NOMINUM BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

# $Id: zone.py,v 1.3 2003/06/21 08:29:25 halley Exp $

import cStringIO
import filecmp
import os
import unittest

import DNS.rdata
import DNS.zone

class ZoneTestCase(unittest.TestCase):

    def testFromFile1(self):
        z = DNS.zone.from_file('example', 'example')
        f = file('example.out', 'w')
        ok = False
        try:
            names = z.nodes.keys()
            names.sort()
            for n in names:
                print >> f, z[n]
            f.close()
            ok = filecmp.cmp('example.out', 'example.good')
        finally:
            os.unlink('example.out')
        self.failUnless(ok)

    def testTorture1(self):
        #
        # Read a zone containing all our supported RR types, and
        # for each RR in the zone, convert the rdata into wire format
        # and then back out, and see if we get equal rdatas.
        #
        f = cStringIO.StringIO()
        o = DNS.name.from_text('example.')
        z = DNS.zone.from_file('example', o)
        for n in z:
            for rds in n:
                for rd in rds:
                    f.seek(0)
                    f.truncate()
                    rd.to_wire(f, origin=o)
                    wire = f.getvalue()
                    rd2 = DNS.rdata.from_wire(rds.rdclass, rds.rdtype,
                                              wire, 0, len(wire),
                                              origin = o)
                    self.failUnless(rd == rd2)

if __name__ == '__main__':
    unittest.main()
